require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require_relative '../../module/DriverUtility'
require_relative '../../module/database/MongoUtility'
require_relative 'cc_SM_request_helper'
require_relative '../../pages/appointments/request_appointment_detail'
require 'watir-scroll'

describe '[Story VAR-9586:CC Request - Select Facility  ("Home") – Multiple Sites (Supported);
           Story VAR-9577:CC Request - Select Facility  ("Home") – One Site (Supported);
           Story VAR-9576:CC Request - Select Service – Multiple DFNs – None are Integrated VistAs, Add Supported Facility Check
           Story VAR-10726:Label update:  Change Facility Location to Location]' do
  include DriverUtility
  include MongoUtility

  before(:all) do
    @db = connectToMongoDB("var-utility")
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
  end

  after(:all) do
    @cc_po.loginLogout.logout
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
  end


  context "CC Request - Select Service – Multiple DFNs – None are Integrated VistAs, Add Supported Facility Check" do
    it "User should able to log in " do
      removeCollection("siteSupportingVAR", @db)
      @cc_po.common.loginEndsOnHome(pw_redacted)
    end

    it "Login and navigate to step 3 wizard of Select Facility" do
      @cc_po.common.selectAddAppointmentButton("CC")
      sleep 3
      expect(@cc_po.communityCare.radio_btn_elements[0].set?).to eq true
      expect(@cc_po.communityCare.radio_btn_elements[1].disabled?).to eq true
      expect(@cc_po.communityCare.unsupported_instr_text_element.text).to eq("This app does not currently support Community Care for the site(s) where you are registered. Please call your location if you are interested in Community Care options.")
    end


    it "Verify the Step 3:Facility section and facilities are not selected by default" do
      @cc_po.communityCare.app_request_bak
      @cc_po.modal.cancel_yes
      restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
      refreshBrowser
      sleep(4)
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.eligibility_yes_element.click
      @cc_po.communityCare.continue_btn
      expect(@cc_po.communityCare.step3_text_element.text.split("\n")).to eq(["Step 3: Location"])
      expect(@cc_po.communityCare.step3_instruction_element.text).to eq("Our records show that you have been seen at more than one VA location. Requests for community care appointments should be sent to your closest VA location for processing.")
      expect(@cc_po.communityCare.select_facility_element.text).to eq("Select a location to process this request:")
      expect(@cc_po.communityCare.facility_radio_btn_elements[1].checked?).to eq false
      @cc_po.communityCare.facility_radio_btn_elements[1].click
      @cc_po.communityCare.exit_button
      @cc_po.modal.cancel_yes
    end

    it "Verify Single supported facility is selected by default, unsupported Facility is grayed out" do
      removeDocument("siteSupportingVAR", "631", @db)
      removeDocument("siteSupportingVAR", "516", @db)
      removeDocument("siteSupportingVAR", "636", @db)
      refreshBrowser
      sleep(3)
      @cc_po.common.waitWhileSpinnerPresent
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.eligibility_yes_element.click
      @cc_po.communityCare.continue_btn
      expect(@cc_po.communityCare.facility_radio_btn_elements[0].checked?).to eq true
      expect(@cc_po.communityCare.facility_radio_btn_elements[1].attribute("disabled")).to eq("true")
      expect(@cc_po.communityCare.disabled_label_facility_element.text).to eq("This location is not currently supporting community care requests.")
      end

  def comp_text(expected_content, actual_content)
    expected_content.each_with_index do |expectedScreenRow, i|
      expect(actual_content[i].to_s.strip).to eq(expectedScreenRow.to_s.strip)
    end
    expect(expected_content.size).to eq(actual_content.size)
  end

  end

  end

